USE `aoe_db`;
CREATE TABLE `trainees` (
  `id` char(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '研修生ID',
  `employee_id` int unsigned NOT NULL COMMENT '社員ID',
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'パスワード',
  `training_id` int unsigned NOT NULL COMMENT '研修ID',
  `phase` tinyint unsigned DEFAULT NULL COMMENT 'フェーズ',
  `training_status_id` int unsigned NOT NULL COMMENT '研修状況ID',
  `guild_id` int unsigned NOT NULL COMMENT 'ギルドID',
  `trainee_class_id` int unsigned NOT NULL COMMENT 'クラスID',
  `grade_id` int unsigned DEFAULT NULL COMMENT 'グレードID',
  `mattermost_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'MattermostID',
  `rank` tinyint unsigned NOT NULL COMMENT 'ランク',
  `ap` tinyint unsigned NOT NULL COMMENT 'AP',
  `tp` tinyint unsigned NOT NULL COMMENT 'TP',
  `alias` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '二つ名',
  `absence_count` int unsigned NOT NULL COMMENT '欠勤回数',
  `lateness_count` int unsigned NOT NULL COMMENT '遅刻回数',
  `remarks` text COLLATE utf8mb4_unicode_ci COMMENT '備考',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trainees_mattermost_id_uindex` (`mattermost_id`),
  KEY `trainees_training_id_phase_index` (`training_id`, `phase`),
  KEY `trainees_training_status_id_foreign` (`training_status_id`),
  KEY `trainees_guild_id_foreign` (`guild_id`),
  KEY `trainees_trainee_class_id_foreign` (`trainee_class_id`),
  KEY `trainees_grade_id_foreign` (`grade_id`),
  CONSTRAINT `trainees_grade_id_foreign` FOREIGN KEY (`grade_id`) REFERENCES `grades` (`id`),
  CONSTRAINT `trainees_guild_id_foreign` FOREIGN KEY (`guild_id`) REFERENCES `guilds` (`id`),
  CONSTRAINT `trainees_trainee_class_id_foreign` FOREIGN KEY (`trainee_class_id`) REFERENCES `trainee_classes` (`id`),
  CONSTRAINT `trainees_training_id_foreign` FOREIGN KEY (`training_id`) REFERENCES `trainings` (`id`),
  CONSTRAINT `trainees_training_status_id_foreign` FOREIGN KEY (`training_status_id`) REFERENCES `training_statuses` (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
INSERT INTO `trainees` (
    `id`,
    `employee_id`,
    `password`,
    `training_id`,
    `phase`,
    `training_status_id`,
    `guild_id`,
    `trainee_class_id`,
    `grade_id`,
    `mattermost_id`,
    `rank`,
    `ap`,
    `tp`,
    `alias`,
    `absence_count`,
    `lateness_count`,
    `remarks`,
    `created_at`,
    `updated_at`
  )
VALUES (
    'GN11103001',
    11103001,
    '$2a$10$U/LRzpAj5.pGWS2LYt..yO0.E1tJ9.QLcWyQ/67JA7Q3z.4PEx0hC',
    3,
    NULL,
    1,
    1,
    5,
    NULL,
    'k-sakanaka',
    3,
    1,
    0,
    NULL,
    0,
    0,
    '6月研修時にランチミーティング',
    '2024-03-22 18:54:31',
    '2024-06-07 12:32:21'
  ),
  (
    'GN11304003',
    11304003,
    '$2y$10$Pn.e5oPT.mD0Ms3YJf2qU.3Kn2q8jbW5MZRtii3PiGFzgx4o2Td7y',
    11,
    1,
    6,
    1,
    4,
    NULL,
    'k-vbecvfbg',
    0,
    1,
    0,
    NULL,
    0,
    2,
    '不合格カウント1\r\nペナルティ1週目',
    '2024-03-22 19:14:14',
    '2024-06-05 14:56:24'
  ),
  (
    'GN11306001',
    11306001,
    '$2y$10$z3OYn9Hpk.3Fm6PuXituFOPt1Hz0jzbKoFr9YVSR0LBcgATBUr3Jm',
    5,
    6,
    1,
    1,
    7,
    NULL,
    'y-gskblruo',
    3,
    2,
    0,
    NULL,
    0,
    0,
    'P6-2,P6-3の課題進行中',
    '2024-03-22 18:59:57',
    '2024-06-03 10:03:18'
  ),
  (
    'GN11811002',
    11811002,
    '$2y$10$4R7Fsjt79dN/NcJQl9k.y.vTtZomuzEa651r0I.8qIVG0sqXzHiZG',
    5,
    4,
    1,
    1,
    6,
    NULL,
    'm-dpaocemt',
    1,
    2,
    0,
    NULL,
    0,
    0,
    NULL,
    '2024-03-22 18:31:54',
    '2024-06-05 18:54:25'
  ),
  (
    'GN11904001',
    11904001,
    '$2y$10$qkwLjHvYidJQu4PneytrguXieEzxdu9gfXkePQdCHxBAbX4EbR5uS',
    6,
    0,
    1,
    1,
    9,
    NULL,
    's-oscxshht',
    0,
    2,
    0,
    NULL,
    0,
    0,
    'PG研修再開時はフェーズ12から',
    '2024-03-22 18:08:04',
    '2024-06-03 10:27:16'
  ),
  (
    'GN11904005',
    11904005,
    '$2y$10$kv722RdUVfZEaY/9/N3zoO8Wqr1B0bass1t7Ra7Jzq..PJd5casES',
    5,
    1,
    2,
    1,
    6,
    NULL,
    'n-albgnytt',
    3,
    1,
    0,
    NULL,
    0,
    0,
    '現場都合で10月から開始予定',
    '2024-03-22 18:16:31',
    '2024-06-13 14:35:30'
  ),
  (
    'GN11904011',
    11904011,
    '$2y$10$tUKfCrcEfhTOQkRdnGkY/OzrChnM7GOfc7a6u8XDkyAI8McUeGatK',
    11,
    2,
    1,
    1,
    5,
    NULL,
    'h-gxewakhx',
    0,
    3,
    0,
    NULL,
    0,
    0,
    NULL,
    '2024-03-27 22:26:25',
    '2024-06-18 10:13:00'
  ),
  (
    'GN11904012',
    11904012,
    '$2y$10$FMzvSTQQmb/pseP/aYBYS.m8..ub9hZNVXgaCBFLYlkR9jh8E39.S',
    13,
    NULL,
    2,
    1,
    6,
    NULL,
    't-kulrunli',
    0,
    1,
    0,
    NULL,
    0,
    1,
    '7月〜テスト設計者研修開始予定',
    '2024-03-28 20:26:27',
    '2024-05-31 16:20:29'
  ),
  (
    'SA11304002',
    11304002,
    '$2y$10$gwSgbcyrQKPve68su6bBWOClkamMydc3QfkL8OiDorOGESpOW8hq6',
    11,
    3,
    3,
    3,
    4,
    NULL,
    'k-kxogkybq',
    0,
    0,
    0,
    NULL,
    0,
    0,
    '休職につき研修休止中',
    '2024-03-22 19:08:33',
    '2024-04-16 10:05:15'
  ),
  (
    'SA11308001',
    11308001,
    '$2y$10$/KOTL5A3IEKjjjhhMrVfrOh99hEvrfjLCPwI9lB8gJFsL1gjFfMMe',
    3,
    NULL,
    1,
    3,
    5,
    NULL,
    'o-sfemohhk',
    2,
    1,
    0,
    NULL,
    1,
    3,
    '6月研修時にランチミーティング実施\r\n現場への不安や要望などを聞き取り',
    '2024-03-22 19:10:27',
    '2024-06-07 12:31:27'
  ),
  (
    'SA11404001',
    11404001,
    '$2y$10$mhGxcJz5zEHJUPK03zrXw.qLHLMykjkrZdD3LJgQLsCFKfKH.CNhq',
    5,
    5,
    1,
    3,
    7,
    NULL,
    'y-lvxsjngj',
    2,
    0,
    0,
    NULL,
    0,
    0,
    'メモを要点をまとめずに取っているせいか、進捗が遅くなりがち\r\nP5-3の課題完了、残りの5-2から実施\r\n\r\n現場の業務内容をヒアリングする必要がある',
    '2024-03-22 18:58:42',
    '2024-06-21 10:08:55'
  ),
  (
    'SA11504001',
    11504001,
    '$2y$10$rEpfonxuAL6UoDTHoDaEVO9y3MoLlxQTx6IKd866vEBRvZja8jHSe',
    5,
    5,
    1,
    3,
    7,
    NULL,
    't-mvnrnjhm',
    2,
    1,
    0,
    NULL,
    0,
    0,
    NULL,
    '2024-03-22 18:26:45',
    '2024-06-12 09:00:02'
  ),
  (
    'SA11804003',
    11804003,
    '$2y$10$AtjdJB1m3KmJiEcIPEkQpuVVaMRLaM0H9J79colkxqiMvHh1HEh66',
    5,
    5,
    1,
    3,
    6,
    NULL,
    'y-tdbtmdsq',
    1,
    0,
    0,
    NULL,
    0,
    1,
    'チャットの表示名変更指示\r\n業務都合で6月研修欠席',
    '2024-03-22 19:02:13',
    '2024-06-12 10:14:19'
  ),
  (
    'SA11807001',
    11807001,
    '$2y$10$ceKMafJ11q1pyt89.Wwu.uC.IID83aron.L13XXRg3VnOYywryisC',
    10,
    2,
    1,
    3,
    5,
    NULL,
    's-cpngmosw',
    1,
    0,
    0,
    NULL,
    0,
    0,
    '不合格カウント1',
    '2024-03-22 18:28:28',
    '2024-06-03 10:14:26'
  ),
  (
    'SA11904003',
    11904003,
    '$2y$12$ob3tHWlpIvqjs6KwH8DOY.rEcqdU3Ylmb/.ckF95fvTvmDvvCVe1K',
    6,
    0,
    1,
    3,
    9,
    NULL,
    'r-gofytqij',
    0,
    3,
    0,
    NULL,
    0,
    0,
    'PG研修再開時はフェーズ12から',
    '2024-03-22 18:13:39',
    '2024-06-03 10:30:47'
  ),
  (
    'SA11904007',
    11904007,
    '$2y$10$5w1dchATw1ph4Kn83o6DxeWnCzo2eXj8QIXhFqgF9akazP3.8Z7C.',
    6,
    0,
    1,
    3,
    9,
    NULL,
    'h-jwldsycb',
    0,
    1,
    0,
    NULL,
    0,
    0,
    'PG研修再開時はフェーズ12から',
    '2024-03-22 18:18:56',
    '2024-06-03 10:27:58'
  ),
  (
    'SY11209001',
    11209001,
    '$2y$10$KpaNjKo68DB8uLKpkFFuv.5RsUaXmz5hVcT/i95XYQQt9lr.Wx9X.',
    5,
    3,
    1,
    4,
    5,
    NULL,
    'r-zswnaboa',
    0,
    0,
    0,
    NULL,
    0,
    0,
    NULL,
    '2024-03-22 19:04:24',
    '2024-06-20 19:03:30'
  ),
  (
    'SY11209002',
    11209002,
    '$2y$10$M8TW.um0.HPpeq8.a9lCtOOreoFO4efGBOhBz5l7gKHhN5t178soy',
    2,
    5,
    1,
    4,
    3,
    NULL,
    'r-liojlcwt',
    0,
    0,
    0,
    NULL,
    0,
    0,
    'S3課題進行中',
    '2024-03-22 19:12:25',
    '2024-05-30 17:35:48'
  ),
  (
    'SY11310001',
    11310001,
    '$2y$10$WLPqEK/RLDWUcQyCQzT9.ur4p6vHemyPYa907dIdXb9GkPGc5zL4O',
    5,
    3,
    1,
    4,
    7,
    NULL,
    't-yqoanxrf',
    0,
    0,
    0,
    NULL,
    0,
    1,
    'P3-2,P3-3の課題進行中\r\n6月の研修はお休み',
    '2024-03-22 19:13:12',
    '2024-05-31 16:14:07'
  ),
  (
    'SY11804001',
    11804001,
    '$2y$10$IkpJAULKaJEx2gGsUcKgreP9547.9SNm1yQYM.ZWYnVTFbI5I.EIe',
    5,
    5,
    1,
    4,
    7,
    NULL,
    'a-ensfthys',
    1,
    1,
    0,
    NULL,
    0,
    0,
    '6月は現場の都合でテスト研修\r\n現場都合でPG研修は10月から開始予定',
    '2024-03-22 17:14:54',
    '2024-06-13 14:36:44'
  ),
  (
    'SY11812001',
    11812001,
    '$2y$10$61Csq8RrkgEryU.l7ajcrev7H7jJ8XoeLKRP9kpBiaH9o4CK7SEpy',
    5,
    2,
    1,
    4,
    6,
    NULL,
    'o-mpmurkwo',
    0,
    0,
    0,
    NULL,
    0,
    0,
    '課題2-2、2-3進行中\r\n現場都合で10月から再開予定',
    '2024-03-22 18:21:34',
    '2024-06-13 14:37:38'
  ),
  (
    'SY11904008',
    11904008,
    '$2y$10$rnBGlNIqRnBz8qcvE7D2FOyfLErQ3t1u3JWpb4bNiUl1cNqhcayBe',
    14,
    0,
    1,
    4,
    7,
    NULL,
    's-nlnifeou',
    1,
    2,
    0,
    NULL,
    0,
    0,
    'LPIC研修終了後はPG研修(P2)に復帰予定',
    '2024-03-22 18:23:49',
    '2024-06-18 10:07:40'
  ),
  (
    'SY11904009',
    11904009,
    '$2y$10$JsejMyoBsRVFPAHhrQiSGOoUM.Uz/TurPr8GwMafMFeEkHSIQWOQG',
    5,
    0,
    2,
    4,
    6,
    1,
    'd-xmdiwvga',
    4,
    1,
    0,
    NULL,
    0,
    0,
    '現場都合で10月から開始予定',
    '2024-03-22 18:24:59',
    '2024-06-13 14:35:22'
  ),
  (
    'UN11405001',
    11405001,
    '$2y$10$hmeftW5wzAF..n/n9wMNe.BCC0eNcexjFt135K1/m3KQcCQP2qLJi',
    5,
    5,
    3,
    2,
    7,
    NULL,
    'r-puzxaqbz',
    3,
    0,
    0,
    NULL,
    0,
    0,
    '5月、6月は研修STOP\r\n(本人より申し出あり。研修内容のレベルが上がるにつれ理解が追い付かないことが多くなりこのまま進めるのは難しいと感じるようになった、少し休んで再開するかどうか考えたいとのこと)\r\n6月末に再開にするかどうか相談。\r\nチャットの表示名変更指示',
    '2024-03-22 18:30:26',
    '2024-06-04 18:58:43'
  ),
  (
    'UN11603001',
    11603001,
    '$2y$10$9nVNL/R/uQDNLpfas0Dva.09GtaKOu/TqA4aBkLsKJKJuY4ucVG.a',
    9,
    8,
    1,
    2,
    4,
    NULL,
    's-qwtmqzqm',
    2,
    3,
    0,
    NULL,
    0,
    0,
    '不合格カウント1',
    '2024-03-22 19:09:34',
    '2024-06-19 09:00:01'
  ),
  (
    'UN11804002',
    11804002,
    '$2y$10$0GsjZDDmad3XtfzmFx9jqecauP7J993yCX0falYs1kkXMa5b16cVS',
    3,
    NULL,
    1,
    2,
    5,
    NULL,
    'y-tekuqisp',
    2,
    0,
    0,
    NULL,
    0,
    0,
    NULL,
    '2024-03-22 18:14:38',
    '2024-05-24 17:21:43'
  ),
  (
    'UN11811001',
    11811001,
    '$2y$10$RfOFZudldhiuZQNSK1Wvg.2x62hBiJTXlkUfEKyvJuoP31FBv52w6',
    5,
    3,
    1,
    2,
    7,
    NULL,
    'm-fkhjhacs',
    1,
    0,
    0,
    NULL,
    0,
    0,
    NULL,
    '2024-03-22 18:22:50',
    '2024-06-05 18:58:36'
  ),
  (
    'UN11904002',
    11904002,
    '$2y$10$orOKEjShBf8fTfKfprPPq.EiPmPtY0BHXqsmwMek5lJM.EwJPxaTO',
    6,
    0,
    1,
    2,
    9,
    NULL,
    'y-qvctksyj',
    0,
    1,
    1,
    NULL,
    0,
    0,
    NULL,
    '2024-03-22 18:11:41',
    '2024-06-14 15:15:32'
  ),
  (
    'UN11904004',
    11904004,
    '$2y$10$lRYTk3uQleFywJdkE6ifKe4bbXTR6dRQ6bdLElYMaTZn/G8Js.jqm',
    11,
    12,
    2,
    2,
    5,
    NULL,
    'y-endqleax',
    0,
    6,
    0,
    NULL,
    0,
    0,
    'PHPフォローアップ研修7月開始予定\r\nフェーズ12から\r\nセキュリティ研修ビデオ要視聴',
    '2024-03-22 18:15:40',
    '2024-06-07 09:00:02'
  ),
  (
    'UN11904013',
    11904013,
    '$2y$12$RnqpnxglZ9PzyQ3g7Jr/Zuyq2pBAfcibtNHbED9FH/4HWA8P.ugvi',
    13,
    NULL,
    2,
    2,
    6,
    NULL,
    'k-uqtwbjun',
    0,
    1,
    0,
    NULL,
    0,
    1,
    '8月〜テスト設計者研修開始予定',
    '2024-03-28 21:28:48',
    '2024-05-31 16:19:39'
  ),
  (
    'UN11905001',
    11905001,
    '$2y$10$8dSxdTmddd.YA.rsUE9dPeGB1XyYCaNoa/PJlh/hSEUn.xO1Z9MZW',
    6,
    NULL,
    1,
    2,
    8,
    NULL,
    'k-qapxfbfi',
    2,
    2,
    2,
    NULL,
    0,
    4,
    NULL,
    '2024-03-27 22:31:49',
    '2024-06-20 10:08:19'
  );
