/*
 * Decompiled with CFR 0.152.
 */
package com.lucent_global.service;

import com.lucent_global.model.mattermost.request.body.Posts;
import com.lucent_global.model.mattermost.response.body.DirectChannel;
import com.lucent_global.model.mattermost.response.body.UserName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class MattermostRestApiService {
    private static final String MATTERMOST_USERNAME_URI = "https://chat.lucent-global.net/api/v4/users/username/";
    private static final String MATTERMOST_DIRECT_CHANNEL_URI = "https://chat.lucent-global.net/api/v4/channels/direct";
    private static final String MATTERMOST_POSTS_URI = "https://chat.lucent-global.net/api/v4/posts";
    private static final String MATTERMOST_ASSISTANT_ID = "dszqb5e5g3nrmnkuyzqyhmxnow";
    private static final String AUTHORIZATION = "Bearer 1ipfh7pymjg6pq4zwjxay6e4ow";
    @Autowired
    private WebClient webClient;

    private UserName getId(String mattermostId) {
        return (UserName)this.webClient.get().uri(MATTERMOST_USERNAME_URI + mattermostId, new Object[0]).header("Authorization", new String[]{AUTHORIZATION}).retrieve().bodyToMono(UserName.class).block();
    }

    private DirectChannel getDirectChannelId(String ... mattermostIds) {
        return (DirectChannel)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(MATTERMOST_DIRECT_CHANNEL_URI, new Object[0])).header("Authorization", new String[]{AUTHORIZATION})).header("Content-Type", new String[]{"application/json"})).bodyValue((Object)mattermostIds).retrieve().bodyToMono(DirectChannel.class).block();
    }

    public void posts(String mattermostId, String message) {
        UserName userName = this.getId(mattermostId);
        String userId = userName.getId();
        DirectChannel directChannel = this.getDirectChannelId(new String[]{MATTERMOST_ASSISTANT_ID, userId});
        String channelId = directChannel.getId();
        Posts requestBody = new Posts(channelId, message);
        ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(MATTERMOST_POSTS_URI, new Object[0])).header("Authorization", new String[]{AUTHORIZATION})).header("Content-Type", new String[]{"application/json"})).bodyValue((Object)requestBody).retrieve().bodyToMono(String.class).block();
    }
}

