/*
 * Decompiled with CFR 0.152.
 */
package com.lucent_global.interceptor;

import com.lucent_global.annotation.Authorize;
import com.lucent_global.component.JwtUtil;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AuthorizeInterceptor
implements HandlerInterceptor {
    @Autowired
    private JwtUtil jwtUtil;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        Class<?> controller;
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        Method method = ((HandlerMethod)handler).getMethod();
        if (AnnotationUtils.findAnnotation((Method)method, Authorize.class) != null ? !this.authorize(request) : AnnotationUtils.findAnnotation(controller = method.getDeclaringClass(), Authorize.class) != null && !this.authorize(request)) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
        return true;
    }

    private boolean authorize(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        if (authorization == null || authorization.isEmpty()) {
            return false;
        }
        if (authorization.indexOf("Bearer ") != 0) {
            return false;
        }
        String token = authorization.replace("Bearer ", "").trim();
        try {
            return this.jwtUtil.isTokenExpired(token) == false;
        }
        catch (ExpiredJwtException exception) {
            return false;
        }
        catch (MalformedJwtException exception) {
            return false;
        }
        catch (Exception exception) {
            throw exception;
        }
    }
}

