/*
 * Decompiled with CFR 0.152.
 */
package com.lucent_global.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.lucent_global.annotation.Authorize;
import com.lucent_global.component.JwtUtil;
import com.lucent_global.model.aoe.TeaScore;
import com.lucent_global.model.aoe.Trainee;
import com.lucent_global.model.lucent.Employee;
import com.lucent_global.model.request.body.UpdatePassword;
import com.lucent_global.service.EmployeeService;
import com.lucent_global.service.MattermostRestApiService;
import com.lucent_global.service.TeaScoreService;
import com.lucent_global.service.TraineeService;
import com.lucent_global.service.UnlockedAchievementService;
import com.lucent_global.view.Views;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"*"}, methods={RequestMethod.GET})
@RestController
@RequestMapping(value={"/api/trainee"})
public class TraineeController {
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private MattermostRestApiService mattermostRestApiService;
    @Autowired
    private TeaScoreService teaScoreService;
    @Autowired
    private TraineeService traineeService;
    @Autowired
    private UnlockedAchievementService unlockedAchievementService;

    @Async
    @Authorize
    @GetMapping(value={"/"})
    @JsonView(value={Views.Public.class})
    public CompletableFuture<ResponseEntity<Trainee>> findByAuthorization(@RequestHeader(value="Authorization", required=true) String authorization) {
        String traineeId = this.getTraineeId(authorization);
        Trainee trainee = this.traineeService.findById(traineeId);
        Integer employeeId = trainee.getEmployeeId();
        Employee employee = this.employeeService.findById(employeeId);
        trainee.setLastName(employee.getLastName());
        trainee.setFirstName(employee.getFirstName());
        return this.jwtUtil.generateTokenResponse(traineeId, (Object)trainee);
    }

    @Async
    @PostMapping(value={"/login"})
    public CompletableFuture<ResponseEntity<Void>> generateToken(@RequestBody Trainee request) {
        String mattermostId = request.getMattermostId();
        String password = request.getPassword();
        String traineeId = this.traineeService.getIdByMattermostIdAndPassword(mattermostId, password);
        return this.jwtUtil.generateTokenResponse(traineeId, null);
    }

    @Async
    @PostMapping(value={"/reset-password"})
    public CompletableFuture<ResponseEntity<Void>> resetPassword(@RequestBody Trainee request) {
        String mattermostId = request.getMattermostId();
        String password = this.traineeService.resetPassword(mattermostId);
        this.mattermostRestApiService.posts(mattermostId, "[\u30ae\u30eb\u30c9\u30ab\u30fc\u30c9](https://training.lucent-global.net/unity-webgl/aoe-webgl/)\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5909\u66f4\u3057\u307e\u3057\u305f\u3002\n`" + password + "`");
        return CompletableFuture.completedFuture(null);
    }

    @Async
    @Authorize
    @PostMapping(value={"/update-password"})
    public CompletableFuture<ResponseEntity<Void>> updatePassword(@RequestHeader(value="Authorization", required=true) String authorization, @RequestBody UpdatePassword request) {
        String traineeId = this.getTraineeId(authorization);
        String currentPassword = request.getCurrentPassword();
        String newPassword = request.getNewPassword();
        this.traineeService.updatePassword(traineeId, currentPassword, newPassword);
        return this.jwtUtil.generateTokenResponse(traineeId, null);
    }

    @Async
    @Authorize
    @GetMapping(value={"/tea-scores"})
    public CompletableFuture<ResponseEntity<List<TeaScore>>> getTeaScoresByMattermostId(@RequestHeader(value="Authorization", required=true) String authorization) {
        String traineeId = this.getTraineeId(authorization);
        List teaScores = this.teaScoreService.findByTraineeId(traineeId);
        return this.jwtUtil.generateTokenResponse(traineeId, (Object)teaScores);
    }

    @Async
    @Authorize
    @GetMapping(value={"/unlocked-achievements"})
    public CompletableFuture<ResponseEntity<List<Integer>>> getUnlockedAchievementsByMattermostId(@RequestHeader(value="Authorization", required=true) String authorization) {
        String traineeId = this.getTraineeId(authorization);
        List unlockedAchievements = this.unlockedAchievementService.findByTraineeId(traineeId);
        List unlockedAchievementIds = unlockedAchievements.stream().map(unlockedAchievement -> unlockedAchievement.getAchievementId()).collect(Collectors.toList());
        return this.jwtUtil.generateTokenResponse(traineeId, unlockedAchievementIds);
    }

    private String getTraineeId(String authorization) {
        String token = authorization.replace("Bearer ", "").trim();
        return this.jwtUtil.extractTraineeId(token);
    }
}

