/*
 * Decompiled with CFR 0.152.
 */
package com.lucent_global.controller;

import com.lucent_global.annotation.Authorize;
import com.lucent_global.component.JwtUtil;
import com.lucent_global.model.aoe.Guild;
import com.lucent_global.service.GuildService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/guilds"})
public class GuildController {
    @Autowired
    GuildService guildService;
    @Autowired
    private JwtUtil jwtUtil;
    @Value(value="${guild.point.counting-period}")
    private String guildPointCountingPeriod;

    @Async
    @Authorize
    @GetMapping(value={"/"})
    public CompletableFuture<ResponseEntity<List<Guild>>> getData(@RequestHeader(value="Authorization", required=true) String authorization) {
        String token = authorization.replace("Bearer ", "").trim();
        String traineeId = this.jwtUtil.extractTraineeId(token);
        List guilds = this.guildService.findAll();
        return this.jwtUtil.generateTokenResponse(traineeId, (Object)guilds);
    }

    @Async
    @Authorize
    @GetMapping(value={"/counting-period"})
    public CompletableFuture<ResponseEntity<Map<String, String>>> getCountingPeriod(@RequestHeader(value="Authorization", required=true) String authorization) {
        String token = authorization.replace("Bearer ", "").trim();
        String traineeId = this.jwtUtil.extractTraineeId(token);
        String[] periods = this.guildPointCountingPeriod.split("~");
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("start", periods[0]);
        response.put("end", 1 < periods.length ? periods[1] : "");
        return this.jwtUtil.generateTokenResponse(traineeId, response);
    }
}

