/*
 * Decompiled with CFR 0.152.
 */
package com.lucent_global.config;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"com.lucent_global.repository.aoe"}, entityManagerFactoryRef="aoeEntityManagerFactory", transactionManagerRef="aoeTransactionManager")
@EntityScan(basePackages={"com.lucent_global.model.aoe"})
public class AoeDataSourceConfig {
    @Primary
    @Bean(name={"aoeDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.aoe")
    public DataSource aoeDataSource() {
        return DataSourceBuilder.create().build();
    }

    @Primary
    @Bean(name={"aoeEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean aoeEntityManagerFactory(@Qualifier(value="aoeDataSource") DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(dataSource);
        em.setPackagesToScan(new String[]{"com.lucent_global.model.aoe"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        return em;
    }

    @Primary
    @Bean(name={"aoeTransactionManager"})
    public PlatformTransactionManager aoeTransactionManager(@Qualifier(value="aoeEntityManagerFactory") EntityManagerFactory aoeEntityManagerFactory) {
        return new JpaTransactionManager(aoeEntityManagerFactory);
    }
}

