/*
 * Decompiled with CFR 0.152.
 */
package com.lucent_global.component;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    @Value(value="${jwt.hmac.sha.key}")
    private String hmacShaKey;

    private SecretKey getSecretKey() {
        return Keys.hmacShaKeyFor((byte[])this.hmacShaKey.getBytes(StandardCharsets.UTF_8));
    }

    public String extractTraineeId(String token) {
        return (String)this.extractClaim(token, Claims::getSubject);
    }

    public Date extractExpiration(String token) {
        return (Date)this.extractClaim(token, Claims::getExpiration);
    }

    private <T> T extractClaim(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.extractAllClaims(token);
        return claimsResolver.apply(claims);
    }

    private Claims extractAllClaims(String token) {
        return (Claims)Jwts.parser().verifyWith(this.getSecretKey()).build().parseSignedClaims((CharSequence)token).getPayload();
    }

    public Boolean isTokenExpired(String token) {
        return this.extractExpiration(token).before(new Date());
    }

    @Async
    private CompletableFuture<String> generateToken(String traineeId) {
        String token = Jwts.builder().subject(traineeId).issuedAt(new Date(System.currentTimeMillis())).expiration(new Date(System.currentTimeMillis() + 900000L)).signWith((Key)this.getSecretKey()).compact();
        return CompletableFuture.completedFuture(token);
    }

    @Async
    public <TResponse> CompletableFuture<ResponseEntity<TResponse>> generateTokenResponse(String traineeId, TResponse response) {
        return this.generateToken(traineeId).thenApply(token -> {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Authorization", token);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(response);
        });
    }

    public Boolean validateToken(String token, String traineeId) {
        String extractedTraineeId = this.extractTraineeId(token);
        return extractedTraineeId.equals(traineeId) && this.isTokenExpired(token) == false;
    }
}

